CREATE OR REPLACE FUNCTION scheduling.resource_context_validation() RETURNS trigger AS $$
  DECLARE
      _pk_column text;
      _pk_exists bool = false;
  BEGIN

      -- this is not aware of namesapces
      _pk_column := pg_attribute.attname
               FROM pg_index
               JOIN pg_class ON pg_class.oid = pg_index.indrelid
               JOIN pg_attribute ON pg_attribute.attnum = any( pg_index.indkey )
                                 AND pg_attribute.attrelid = pg_class.oid
               JOIN pg_namespace ON pg_namespace.oid = pg_class.relnamespace
              WHERE pg_index.indrelid = new.context::regclass
                AND pg_index.indisprimary
      ;

      -- override for ksv, since its PK is ks_abt ಠ_ಠ
      IF new.context = 'ksv' THEN
          _pk_column := 'ks_id';
      END IF;

      IF _pk_column IS NULL THEN
          RAISE EXCEPTION 'cannot verify context of »%«, no PK found', new.context;
      END IF;

      EXECUTE format(
          'select count(*) > 0 from %I WHERE %I = %L',
          new.context,
          _pk_column,
          new.context_id
      ) INTO _pk_exists;

      IF NOT _pk_exists THEN
          RAISE EXCEPTION 'non existing pk in % (%)', new.context, new.context_id;
      END IF;

      RETURN new;

  END $$ language plpgsql;
  --
  DROP TRIGGER IF EXISTS resource_context_validation ON scheduling.resource;
  CREATE TRIGGER resource_context_validation
    BEFORE INSERT OR UPDATE
    ON scheduling.resource
    FOR EACH ROW
    EXECUTE PROCEDURE scheduling.resource_context_validation();


